package dbms;

import java.util.Vector;
import javax.swing.JTable;
import java.rmi.Remote;
import java.rmi.RemoteException;
import connectfour.*;

public interface DBMS extends Remote {
	
	public boolean initialize() throws RemoteException;
	public void createTables() throws RemoteException;
	public void dropTables() throws RemoteException;
	public void clearTables() throws RemoteException;
	public void dropUserDataTable() throws RemoteException;
	public void dropGameHistoryTable() throws RemoteException;
	public void createUserDataTable() throws RemoteException;
	public void createGameHistoryTable() throws RemoteException;
	public boolean createUser(String userName, String password) throws RemoteException;
	public String[] getUserNames() throws RemoteException;
	public String[] getUserNamesFromHistory() throws RemoteException;
	public boolean deleteUser(String userName) throws RemoteException;
	public void deleteUserHistory(String userName) throws RemoteException;
	public boolean addWin(String userName) throws RemoteException;
	public boolean addLoss(String userName) throws RemoteException;
	public boolean addDraw(String userName) throws RemoteException;
	public boolean addMatch(MatchData match) throws RemoteException;
	public boolean userLogin(String userName, String password) throws RemoteException;
	public boolean userLogout(String userName) throws RemoteException;
	public boolean changePassword(String userName, String oldPassword, String newPassword) throws RemoteException;
	public boolean addListener(DBMSListener listener) throws RemoteException;
	public boolean removeListener(DBMSListener listener) throws RemoteException;
	public int[] getPlayerStats(String userName) throws RemoteException;
	public Vector<MatchData> getPlayerHistory(String playerName) throws RemoteException;
	public Vector<MatchData> getMatchHistory(String firstPlayerName, String secondPlayerName) throws RemoteException;
	public void close() throws RemoteException;
	public void updateTable(String tableName, JTable table, boolean autoSizeColumns) throws RemoteException;
	
}
